@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content py-3">
		<div class="invoice-wrapper">
			<div class="card elevation-0 border mb-0 rounded-0 border-bottom-0">
				<div class="card-body  border-bottom-0">
					<div class="row">
						<div class="col-12 d-flex justify-content-between">
							<div class="gym-details d-flex">
								<div class="logo">
									<div class="logo-image" style="background-image: url('{{ logo_url('logo') }}');">
									</div>
								</div>
								<div class="details ml-4">
									<p class="text-dark mb-1">{{ get_option('brand_name') }}</p>
									<p class="mb-0 text-secondary">{{ get_option('address') }}</p>
									<p class="mb-0 text-secondary">{{ get_option('country') }}</p>
								</div>
							</div>
							<div class="inv-details">
								<p class="text-dark mb-1">{{ __('invoice.invoice_no') }}</p>
								<p class="mb-0 text-secondary float-right">{{ format_invoice_no($invoice->id) }}</p>
							</div>
						</div>
					</div>
					<div class="row biller-info">
						<div class="col-4">
							<p class="text-dark mb-1">{{ __('invoice.bill_to') }}</p>
							<p class="mb-0 text-secondary">{{ $invoice->member->name }}</p>
							<p class="mb-0 text-secondary">{{ $invoice->member->address }}</p>
							<p class="mb-0 text-secondary">{{ $invoice->member->phone }}</p>
						</div>
						<div class="col-4">
							<p class="text-dark mb-1 ">{{ __('invoice.invoice_date') }}</p>
							<p class="mb-0 text-secondary">{{ format_date($invoice->created_at) }}</p>
						</div>
						<div class="col-4">
							<p class="text-dark mb-1">{{ __('invoice.amount_due') }}</p>
							<p class="mb-0 text-secondary">{{ format_amount(due_amount($invoice->transactions)) }}</p>
						</div>
					</div>
					<div class="row">
						<div class="col-12">
							<table class="table table-striped custom-table-bordered">
								<thead>
									<tr>
										<th class="">{{ __('invoice.th_membership_type') }}</th>
										<th>{{ __('invoice.th_duration') }}</th>
										<th>{{ __('invoice.th_membership_fee') }}</th>
										<th>{{ __('invoice.th_total') }}</th>
									</tr>
								</thead>
								<tbody>
									<tr class="text-secondary">
										<td>{{ $invoice->membership_type->name }}</td>
										<td>{{ pluralize($invoice->membership_type->duration) }}</td>
										<td>{{ format_amount($invoice->membership_type->amount) }}</td>
										<td>{{ format_amount($invoice->membership_type->amount) }}</td>
									</tr>
								</tbody>
							</table>
						</div>
					</div>
					<div class="row mt-5">
						<div class="offset-8 col-4 border-bottom  px-0 border-grey">
							<div class="d-flex justify-content-between pb-3">
								<span class="">{{ __('invoice.subtotal') }}</span>
								<span class="text-secondary">{{ format_amount($invoice->membership_type->amount)
									}}</span>
							</div>
						</div>
						<div class="offset-8 col-4 px-0 mb-2 pt-3">
							<div class="d-flex justify-content-between">
								<span class="">{{ __('invoice.total') }}</span>
								<span class="text-secondary">{{ format_amount($invoice->membership_type->amount)
									}}</span>
							</div>
						</div>
						<div class="offset-8 col-4  px-0 pb-3">
							<div class="d-flex justify-content-between">
								<span class="">{{ __('invoice.amount_paid') }}</span>
								<span class="text-secondary">{{ format_amount(paid_amount($invoice->transactions))
									}}</span>
							</div>
						</div>
						<div class="offset-8 col-4 border-top  px-0  border-grey pt-3">
							<div class="d-flex justify-content-between">
								<span class="">{{ __('invoice.amount_payable', ['currency' => get_option('currency',
									'USD')]) }}</span>
								<span class="text-secondary">{{ format_amount(due_amount($invoice->transactions))
									}}</span>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row no-print">
				<div class="col-12 mt-0">
					<a href="{{ route('invoice.print', $invoice->id) }}" rel="noopener" target="_blank"
						class=" btn-lg btn rounded-0 btn-default btn-block  "><i class="fas fa-print"></i> {{
						__('invoice.print') }}</a>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection